/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.container.item;

import com.technicalitiesmc.lib.container.item.ItemContainer;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;

public class ItemContainerSlice
implements ItemContainer {
    private final ItemContainer parent;
    private final int from;
    private final int size;

    public ItemContainerSlice(ItemContainer parent, int from, int size) {
        this.parent = parent;
        this.from = from;
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ItemStack get(int slot) {
        Objects.checkIndex(slot, this.size);
        return this.parent.get(slot + this.from);
    }

    @Override
    public void set(int slot, ItemStack stack) {
        Objects.checkIndex(slot, this.size);
        this.parent.set(slot + this.from, stack);
    }

    @Override
    public boolean isValid(int slot, ItemStack stack) {
        Objects.checkIndex(slot, this.size);
        return this.parent.isValid(slot + this.from, stack);
    }

    @Override
    public ItemContainer slice(int from, int to) {
        Objects.checkFromToIndex(from, to, this.size());
        return new ItemContainerSlice(this.parent, this.from + from, to - from);
    }
}

